/*
 * Decompiled with CFR 0.152.
 */
package com.jhe.hexed;

import com.jhe.hexed.JHexEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public class JHexEditorASCII
extends JComponent
implements MouseListener,
KeyListener {
    private JHexEditor he;

    public JHexEditorASCII(JHexEditor he) {
        this.he = he;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(he);
    }

    @Override
    public Dimension getPreferredSize() {
        this.debug("getPreferredSize()");
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        this.debug("getMinimumSize()");
        Dimension d = new Dimension();
        FontMetrics fn = this.getFontMetrics(JHexEditor.font);
        int h = fn.getHeight();
        int nl = this.he.getLineas();
        d.setSize((fn.stringWidth(" ") + 1) * 16 + this.he.border * 2 + 1, h * nl + this.he.border * 2 + 1);
        return d;
    }

    @Override
    public void paint(Graphics g) {
        this.debug("paint(" + g + ")");
        this.debug("cursor=" + this.he.selectionData.cursor + " buffer length=" + this.he.data.getBufferLength());
        Dimension d = this.getMinimumSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width, d.height);
        g.setColor(Color.black);
        g.setFont(JHexEditor.font);
        int ini = this.he.getInicio() * 16;
        int fin = ini + this.he.getLineas() * 16;
        if (fin > this.he.data.getBufferLength()) {
            fin = this.he.data.getBufferLength();
        }
        int x = 0;
        int y = 0;
        int n = ini;
        while (n < fin) {
            if (n >= this.he.selectionData.getSelectionFirst() && n <= this.he.selectionData.getSelectionLast()) {
                if (this.he.selectionData.isInSelection()) {
                    g.setColor(Color.yellow);
                    this.he.fondo(g, x, y, 1);
                    g.setColor(Color.black);
                } else if (n == this.he.selectionData.cursor) {
                    g.setColor(Color.blue);
                    if (this.hasFocus()) {
                        this.he.fondo(g, x, y, 1);
                    } else {
                        this.he.cuadro(g, x, y, 1);
                    }
                    if (this.hasFocus()) {
                        g.setColor(Color.white);
                    } else {
                        g.setColor(Color.black);
                    }
                } else {
                    g.setColor(Color.blue);
                    this.he.fondo(g, x, y, 1);
                    g.setColor(Color.white);
                }
            } else if (n == this.he.selectionData.cursor) {
                g.setColor(Color.blue);
                if (this.hasFocus()) {
                    this.he.fondo(g, x, y, 1);
                } else {
                    this.he.cuadro(g, x, y, 1);
                }
                if (this.hasFocus()) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(Color.black);
                }
            } else {
                g.setColor(Color.black);
            }
            byte value = this.he.data.getBufferByte(n);
            String s = "" + new Character((char)value);
            if (value < 20 || value > 126) {
                s = "\u0010";
            }
            this.he.printString(g, s, x++, y);
            if (x == 16) {
                x = 0;
                ++y;
            }
            ++n;
        }
    }

    private void debug(String s) {
        this.he.debugPrintLine("JHexEditorASCII ==> " + s);
    }

    public int calcularPosicionRaton(int x, int y) {
        FontMetrics fn = this.getFontMetrics(JHexEditor.font);
        this.debug("x=" + (x /= fn.stringWidth(" ") + 1) + " ,y=" + (y /= fn.getHeight()));
        return x + (y + this.he.getInicio()) * 16;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.debug("mouseClicked(" + e + ")");
        this.he.selectionData.cursor = this.calcularPosicionRaton(e.getX(), e.getY());
        this.requestFocus();
        this.he.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.debug("keyTyped(" + e + ")");
        this.he.data.setBufferByte(this.he.selectionData.cursor, (byte)e.getKeyChar());
        if (this.he.selectionData.cursor != this.he.data.getBufferLength() - 1) {
            ++this.he.selectionData.cursor;
        }
        this.he.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.debug("keyPressed(" + e + ")");
        this.he.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.debug("keyReleased(" + e + ")");
        this.he.keyReleased(e);
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }
}

